/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.checks;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.MissingAttribute;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.signals.execution.WatchExecutionContext;
import com.floragunn.signals.watch.checks.AbstractSearchInput;
import com.floragunn.signals.watch.checks.Check;
import com.floragunn.signals.watch.init.WatchInitializationService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class SearchTemplateInput
extends AbstractSearchInput {
    private String id;
    private Map<String, Object> params;

    static Check create(WatchInitializationService watchInitService, DocNode jsonObject) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonObject, validationErrors);
        vJsonNode.used(new String[]{"type", "request"});
        String name = vJsonNode.get("name").asString();
        String target = vJsonNode.get("target").asString();
        String id = vJsonNode.get("id").required().asString();
        ImmutableList indices = vJsonNode.get("request.indices").asListOfStrings();
        DocNode template = jsonObject.getAsNode("request.template");
        if (template == null || template.isNull()) {
            validationErrors.add((ValidationError)new MissingAttribute("request.template", (Object)jsonObject));
        }
        TimeValue timeout = (TimeValue)vJsonNode.get("timeout").byString(v -> TimeValue.parseTimeValue((String)v, (String)"timeout"));
        SearchType searchType = (SearchType)vJsonNode.get("search_type").asEnum(SearchType.class);
        IndicesOptions indicesOptions = null;
        if (vJsonNode.hasNonNull("indices_options")) {
            try {
                indicesOptions = SearchTemplateInput.parseIndicesOptions(jsonObject.getAsNode("indices_options"));
            }
            catch (ConfigValidationException e) {
                validationErrors.add("indices_options", e);
            }
        }
        vJsonNode.checkForUnusedAttributes();
        validationErrors.throwExceptionForPresentErrors();
        SearchTemplateInput result = new SearchTemplateInput(name, target, (List<String>)indices, id, (Map<String, Object>)(template.get("params") != null ? template.getAsNode("params").toMap() : null));
        result.timeout = timeout;
        result.searchType = searchType;
        result.indicesOptions = indicesOptions;
        result.compileScripts(watchInitService);
        return result;
    }

    public SearchTemplateInput(String name, String target, List<String> indices, String id, Map<String, Object> params) {
        super(name, target, indices);
        this.id = id;
        this.params = params;
    }

    @Override
    protected Script createTemplateScript() {
        return new Script(ScriptType.STORED, "mustache", this.id, this.params);
    }

    @Override
    protected Map<String, Object> getTemplateScriptParamsAsMap(WatchExecutionContext ctx) {
        Map<String, Object> result = super.getTemplateScriptParamsAsMap(ctx);
        result.putAll(this.params);
        return result;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("type", "search");
        builder.field("name", this.name);
        builder.field("target", this.target);
        if (this.timeout != null) {
            builder.field("timeout", this.timeout.getStringRep());
        }
        if (this.searchType != null) {
            builder.field("search_type", this.searchType.name().toLowerCase());
        }
        builder.startObject("request");
        builder.field("indices", (Iterable)this.indices);
        builder.startObject("template");
        builder.field("id", this.id);
        builder.field("params");
        builder.map(this.params);
        builder.endObject();
        builder.endObject();
        if (this.indicesOptions != null) {
            builder.field("indices_options", (ToXContent)this.indicesOptions);
        }
        return builder;
    }
}

